/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.internal.startup;

import com.aptana.core.logging.IdeLog;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.internal.Portal;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class PortalStartup
implements IStartup {
    private static final String TITANIUM_MOBILE_NATURE = "com.appcelerator.titanium.mobile.nature";

    public void earlyStartup() {
        UIJob job = new UIJob("Launching Aptana Developer Toolbox..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Portal portal = Portal.getInstance();
                if (portal.shouldOpenPortal()) {
                    portal.openPortal(null, "com.aptana.portal.ui.browser.portal");
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(500L);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)new ProjectCreateListener(), 1);
    }

    private class ProjectCreateListener
    implements IResourceChangeListener {
        private ProjectCreateListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event == null || event.getDelta() == null) {
                return;
            }
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource;
                        if (delta.getKind() == 1 && (resource = delta.getResource()) instanceof IProject && resource.isAccessible() && ((IProject)resource).getNature(PortalStartup.TITANIUM_MOBILE_NATURE) != null) {
                            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.portal.ui");
                            prefs.put("recently_created_project", resource.getName());
                            try {
                                prefs.flush();
                            }
                            catch (BackingStoreException e) {
                                IdeLog.logWarning((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

